<!---
obfuscate.cfm - Coldfusion source of an implementation of Spam-me-not by Andreas Neudecker
Copyright (c) 2003 by Andreas Neudecker, Adam Hope.
Licensed under the GNU General Public License (GPL), see http://www.gnu.org/copyleft/
Last changes: 2003-08-27 by Adam Hope
--->


<cfscript>
function encodeString (originalString, mode) {
	encodedString = "";
	nowCodeString = "";
	originalLength = len(originalString);
	for (i = 1; i LTE originalLength; i = i + 1) {
		switch (mode) {
			case 1:	// Decimal code:
				nowCodeString = "&##" & asc(mid(originalString, i, 1)) & ";";
			break;
			case 2: // Hexadecimal code:
				nowCodeString = "&##x" & FormatBaseN(asc(mid(originalString, i, 1)), 16) & ";";
			break;
			case 3: // Random encoding - which mode now?
				randomNumber = ceiling(3 * rand());
				switch (randomNumber) {
					case 1: // Random encoding - decimal code:
						nowCodeString = "&##" & asc(mid(originalString, i, 1)) & ";";
					break;
					case 2: // Random encoding - hexadecimal code:
						nowCodeString = "&##x" & FormatBaseN(asc(mid(originalString, i, 1)), 16) & ";";
					break;
					case 3: // Random encoding - don't encode, use character itself:
						nowCodeString = mid(originalString, i, 1);
					break;
					default:
						return("ERROR: wrong random number.");
					break;
				}
			break;
			case 4: // Don't encode, use character itself:
				nowCodeString = mid(originalString, i, 1);
			break;
			default:
				return ("ERROR: wrong encoding mode.");
			break;
		}
		encodedString = encodedString & nowCodeString;
	}
	return (encodedString);
}

function obfuscate (emailAddress, encMode, type) {
	mailto = "mailto:";
	aHref = '<a href="';
	aHrefEnd = '">';
	endHref = '</a>';
	encodedMailto = encodeString (mailto, encMode);
	encodedEmail = encodeString(emailAddress, encMode);
	switch (type) {
		case 'fullLink':
			return (aHref & encodedMailto & encodedEmail & aHrefEnd & encodedEmail & endHref);
		break;
		default:
			return (encodedEmail);
		break;
	}
}
</cfscript>