/* Spam-me-not.js - JavaScript source of Spam-me-not. */
/* Copyright (c) 2003 by Andreas Neudecker */
/* Licensed under the GNU General Public License (GPL), see http://www.gnu.org/copyleft/ */
/* Last changes: 2003-09-23 by Andreas Neudecker */

/* This is where the real encoding is done */
function encodeString (originalString, mode) {
	var encodedString = "";
	var nowCodeString = "";
	var randomNumber = -1;
	var originalLength = originalString.length;
	for (var i = 0; i < originalLength; i++) {
		switch (mode) {
			case 1:	// Decimal code:
				nowCodeString = "&#" + Number(originalString.charCodeAt(i)).toString() + ";";
			break;
			case 2: // Hexadecimal code:
				nowCodeString = "&#x" + Number(originalString.charCodeAt(i)).toString(16) + ";";
			break;
			case 3: // Random encoding - which mode now?
				randomNumber = Math.ceil(2 * Math.random());
				switch (randomNumber) {
					case 1: // Random encoding - decimal code:
						nowCodeString = "&#" + Number(originalString.charCodeAt(i)).toString() + ";";
					break;
					case 2: // Random encoding - hexadecimal code:
						nowCodeString = "&#x" + Number(originalString.charCodeAt(i)).toString(16) + ";";
					break;
					// eliminated this option, because in rare cases it could lead to 
					// a readable email address. (2003-09-11, Andreas)
					//case 3: // Random encoding - don't encode, use character itself:
					//	nowCodeString = originalString.charAt(i);
					//break;
					default:
						return("ERROR: wrong random number.");
					break;
				}
			break;
			case 4: // Don't encode, use character itself:
				nowCodeString = originalString.charAt(i);
			break;
			default:
				return ("ERROR: wrong encoding mode.");
			break;
		}
		encodedString += nowCodeString;
	}
	return (encodedString);
}


/* The "main()" of this script */
function obfuscateEmail () {
	var mailto = "mailto:";
	var aHref = "\<a href=\"";
	var aHrefEnd = "\">";
	var endHref = "\<\/a>";
	var mode = Number(document.nospam.modeSelect.value);
	// generate encoded "mailto:"
	var encodedMailto = encodeString (mailto, mode);
	
	if (document.nospam.realName.value == "") {
		if (document.nospam.wasEmpty.value == 0) {
			document.nospam.linkText.value = 1;
			document.nospam.wasEmpty.value = 1;
		}
	}
	else { // realName.value has text
		if (document.nospam.wasEmpty.value == 1) {
			document.nospam.linkText.value = 2;
			document.nospam.wasEmpty.value = 0;
		}
	}

	if (document.nospam.email.value != "") {
		var oriEmail = document.nospam.email.value
		if (oriEmail != "") {
			var encodedEmail = encodeString (oriEmail, mode);
			// email only
			document.nospam.encodedEmail.value = encodedEmail;
			// mailto: + email
			document.nospam.encodedMailtoEmail.value = encodedMailto + encodedEmail;
			// complete link
			if (Number(document.nospam.linkText.value) == 1)
				document.nospam.completeEmailLink.value = aHref + encodedMailto + encodedEmail + aHrefEnd + encodedEmail + endHref;
			else
				document.nospam.completeEmailLink.value = aHref + encodedMailto + encodedEmail + aHrefEnd + document.nospam.realName.value + endHref;
		}
	}
	else {
		document.nospam.completeEmailLink.value = "No email given.";
	}
}

